<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->string('product_name');
            $table->string('sku')->unique();
            $table->string('unit');
            $table->string('category'); // e.g., Bahan Bangunan, Peralatan
            $table->integer('stock_in')->default(0);
            $table->integer('stock_out')->default(0);
            $table->integer('current_stock')->default(0);
            $table->timestamps();
        });

        Schema::create('inventory_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('inventory_id')->constrained()->cascadeOnDelete();
            $table->enum('activity_type', ['Stock In', 'Stock Out']);
            $table->enum('reference_type', ['Purchase', 'Sale']);
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->integer('quantity');
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_logs');
        Schema::dropIfExists('inventories');
    }
};
