<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Inventory extends Model
{
    use HasFactory;

    protected $fillable = ['product_name', 'sku', 'unit', 'category', 'stock_in', 'stock_out', 'current_stock', 'selling_price'];

    public function logs()
    {
        return $this->hasMany(InventoryLog::class);
    }
}
