<x-filament::page>
    <div class="space-y-6">
        @forelse ($reminders as $item)
            <x-filament::card>
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold">
                            {{ $item['motorcycle']->plate_number }} - {{ $item['motorcycle']->brand }} {{ $item['motorcycle']->type }}
                        </h2>
                        <ul class="list-disc ml-6 mt-1 text-sm text-gray-700">
                            @foreach ($item['reminders'] as $reminder)
                                <li>{{ $reminder }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <div>
                        <x-filament::button
                            tag="a"
                            color="primary"
                            href="{{ \App\Filament\Resources\MotorcycleResource::getUrl('edit', ['record' => $item['motorcycle']->id]) }}"
                        >
                            Lihat
                        </x-filament::button>
                    </div>
                </div>
            </x-filament::card>
        @empty
            <x-filament::card>
                <p class="text-gray-500 text-sm">Tidak ada pengingat hari ini.</p>
            </x-filament::card>
        @endforelse
    </div>
</x-filament::page>