<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financial_reports', function (Blueprint $table) {
            $table->id();
            $table->dateTime('transaction_date');
            $table->enum('type', ['debit', 'credit']); // credit = uang masuk, debit = uang keluar
            $table->decimal('amount', 12, 2);
            $table->string('description');
            $table->morphs('source'); // untuk polymorphic relation (misal dari payment, pembelian, dll)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financial_reports');
    }
};
