<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('motorcycles', function (Blueprint $table) {
            $table->id();
            $table->string('plate_number')->unique();
            $table->string('brand');
            $table->string('type');
            $table->integer('cc');
            $table->integer('year');
            $table->string('color');
            $table->enum('status', ['Tersedia', 'Disewa', 'Maintenance']);
            $table->date('oil_date');
            $table->date('stnk_date');
            $table->decimal('daily_price', 12, 2);
            $table->decimal('weekly_price', 12, 2);
            $table->decimal('monthly_price', 12, 2);
            $table->string('photo');
            $table->timestamps();
        });

        Schema::create('stnk_dates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('motorcycle_id')->constrained()->onDelete('cascade');
            $table->date('stnk_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stnk_dates');
        Schema::dropIfExists('motorcycles');
    }
};
