<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Motorcycle extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = [
        'plate_number',
        'brand',
        'type',
        'cc',
        'year',
        'color',
        'status',
        'oil_date',
        'stnk_date',
        'daily_price',
        'weekly_price',
        'monthly_price',
        'photo',
    ];

    protected $casts = [
        'oil_date' => 'date',
        'stnk_date' => 'date',
        'daily_price' => 'decimal:2',
        'weekly_price' => 'decimal:2',
        'monthly_price' => 'decimal:2',
    ];

    // Relasi ke STNK dates
    public function stnkDates()
    {
        return $this->hasMany(StnkDate::class);
    }

    // Optional: relasi ke Rentals nanti
    public function rentals()
    {
        return $this->hasMany(Rental::class);
    }

    public function maintenances()
    {
        return $this->hasMany(Maintenance::class);
    }
}
