<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class FinancialReport extends Model
{
    protected $fillable = [
        'transaction_date',
        'type',           // 'debit' | 'credit'
        'amount',
        'description',
        'source_id',
        'source_type',
    ];

    protected $casts = [
        'transaction_date' => 'datetime',
        'amount'           => 'decimal:2',
    ];

    public function source(): MorphTo
    {
        return $this->morphTo();
    }
}
