<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Customer extends Model implements HasMedia
{
    use InteractsWithMedia;

    protected $fillable = [
        'name',
        'nik',
        'phone',
        'emergency_number',
        'address',
        'gender',
        'birth_date',
        'category',
        'status',
        'social_media_link',
        'colleague_info',
    ];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('ktp')->singleFile();
        $this->addMediaCollection('ticket_perjalanan')->singleFile();
        $this->addMediaCollection('booking_hotel')->singleFile();
        $this->addMediaCollection('ktm')->singleFile();
        $this->addMediaCollection('bukti_kos')->singleFile();
        $this->addMediaCollection('id_kerja')->singleFile();
    }
}
