<?php

namespace App\Filament\Widgets;

use App\Models\FinancialReport;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class FinancialSummaryWidget extends BaseWidget
{
    protected ?string $heading = 'Ringkasan Keuangan';

    protected function getStats(): array
    {
        // Baca filter tanggal dari query table (kalau ada)
        $filters = request()->input('tableFilters', []);
        $from = data_get($filters, 'tanggal.from');
        $until = data_get($filters, 'tanggal.until');

        $query = FinancialReport::query();
        if ($from)  $query->whereDate('transaction_date', '>=', $from);
        if ($until) $query->whereDate('transaction_date', '<=', $until);

        $credit = (clone $query)->where('type', 'credit')->sum('amount');
        $debit  = (clone $query)->where('type', 'debit')->sum('amount');
        $saldo  = $credit - $debit;

        return [
            Stat::make('Total Pemasukan', 'Rp ' . number_format($credit, 0, ',', '.'))
                ->description('Credit')
                ->descriptionIcon('heroicon-o-arrow-up-circle')
                ->color('success'),

            Stat::make('Total Pengeluaran', 'Rp ' . number_format($debit, 0, ',', '.'))
                ->description('Debit')
                ->descriptionIcon('heroicon-o-arrow-down-circle')
                ->color('danger'),

            Stat::make('Saldo', 'Rp ' . number_format($saldo, 0, ',', '.'))
                ->description('Credit - Debit')
                ->descriptionIcon('heroicon-o-currency-dollar')
                ->color($saldo >= 0 ? 'success' : 'danger'),
        ];
    }
}