<?php

namespace App\Filament\Resources\RentalResource\RelationManagers;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Forms\Components\FileUpload;
use Filament\Resources\RelationManagers\RelationManager;

class PaymentsRelationManager extends RelationManager
{
    protected static string $relationship = 'payments';
    protected static ?string $title = 'Pembayaran';

    public function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('amount')
                ->label('Jumlah')
                ->numeric()
                ->prefix('Rp')
                ->required(),

            Forms\Components\Select::make('payment_type')
                ->label('Tipe')
                ->options([
                    'DP'        => 'DP',
                    'Pelunasan' => 'Pelunasan',
                    'Denda'     => 'Denda',
                ])
                ->required(),

            Forms\Components\Select::make('payment_method')
                ->label('Metode')
                ->options([
                    'Cash'     => 'Cash',
                    'Transfer' => 'Transfer',
                    'E-Wallet' => 'E-Wallet',
                ])
                ->required(),

            Forms\Components\DateTimePicker::make('payment_date')
                ->label('Tanggal & Waktu Bayar')
                ->seconds(false)
                ->required(),

            Forms\Components\Textarea::make('notes')
                ->label('Catatan')
                ->columnSpanFull(),

            FileUpload::make('proof_file')
                ->label('Bukti Transfer')
                ->directory('payments/proofs')
                ->visibility('public')
                ->downloadable()
                ->previewable()
                ->maxSize(8192), // 2MB
        ])->columns(2);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('amount')->money('IDR', true),
                Tables\Columns\BadgeColumn::make('payment_type')
                    ->colors([
                        'warning' => 'DP',
                        'success' => 'Pelunasan',
                        'danger'  => 'Denda',
                    ]),
                Tables\Columns\BadgeColumn::make('payment_method')
                    ->colors([
                        'primary' => 'Cash',
                        'info'    => 'Transfer',
                        'success' => 'E-Wallet',
                    ]),
                Tables\Columns\TextColumn::make('payment_date')->dateTime('d M Y H:i'),
                Tables\Columns\TextColumn::make('notes')->limit(30),
                Tables\Columns\ImageColumn::make('proof_file')
                    ->label('Bukti Transfer')
                    ->square()
                    ->size(50)
                    ->defaultImageUrl(asset('images/no-image.png')),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make()->requiresConfirmation(),
            ]);
    }
}