<?php

namespace App\Filament\Resources\RentalResource\Pages;

use App\Filament\Resources\RentalResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;

class ListRentals extends ListRecords
{
    protected static string $resource = RentalResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    protected function getTableActions(): array
    {
        return [
            Tables\Actions\EditAction::make(),
            Tables\Actions\Action::make('extend')
                ->label('Perpanjang')
                ->form([
                    Forms\Components\DatePicker::make('new_end_date')
                        ->label('Tanggal Selesai Baru')
                        ->required(),
                ])
                ->action(function ($record, array $data) {
                    $record->end_date = $data['new_end_date'];
                    $days = Carbon::parse($record->start_date)->diffInDays(Carbon::parse($record->end_date)) + 1;
                    $record->total_price = $days * $record->price_per_day;
                    $record->save();
                }),
            Tables\Actions\Action::make('return')
                ->label('Kembalikan Motor')
                ->color('success')
                ->icon('heroicon-o-arrow-uturn-left')
                ->requiresConfirmation()
                ->action(function ($record) {
                    // 1. Ambil motor terkait
                    $motorcycle = $record->motorcycle;
                    $motorcycle->status = 'Tersedia';
                    $motorcycle->save();

                    // 2. Hitung keterlambatan
                    $end = Carbon::parse($record->rental_end);
                    $now = Carbon::now();

                    $hoursLate = $end->lt($now) ? $end->diffInHours($now) : 0;

                    // 3. Hitung denda
                    $penalty = $hoursLate * 15000;

                    // 4. Update rental
                    $record->status = 'Selesai';
                    $record->penalty_fee = $penalty;
                    $record->total_amount = $record->total_amount + $penalty;
                    $record->save();
                }),
        ];
    }
}
