<?php

namespace App\Filament\Resources\MotorcycleResource\RelationManagers;

use Filament\Forms;
use Filament\Tables;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables\Columns\TextColumn;

class StnkDatesRelationManager extends RelationManager
{
    protected static string $relationship = 'stnkDates';

    protected static ?string $title = 'Riwayat STNK';

    public function form(Forms\Form $form): Forms\Form
    {
        return $form->schema([
            Forms\Components\DatePicker::make('stnk_date')
                ->label('Tanggal STNK')
                ->required(),
        ]);
    }

    public function table(Tables\Table $table): Tables\Table
    {
        return $table
            ->columns([
                TextColumn::make('stnk_date')->label('Tanggal STNK')->date(),
                TextColumn::make('created_at')->label('Ditambahkan')->since(),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}