<?php

namespace App\Filament\Resources;

use App\Filament\Resources\MotorcycleResource\Pages;
use App\Filament\Resources\MotorcycleResource\RelationManagers\MaintenancesRelationManager;
use App\Filament\Resources\MotorcycleResource\RelationManagers\StnkDatesRelationManager;
use App\Models\Motorcycle;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\BadgeColumn;

class MotorcycleResource extends Resource
{
    protected static ?string $model = Motorcycle::class;

    protected static ?string $navigationIcon = 'heroicon-o-truck';
    protected static ?string $navigationGroup = 'Rental Motor';
    protected static ?string $modelLabel = 'Motor';
    protected static ?string $pluralModelLabel = 'Motorcycles';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Grid::make(2)->schema([
                    TextInput::make('plate_number')
                        ->label('No. Polisi')
                        ->required()
                        ->unique(Motorcycle::class, 'plate_number'),
    
                    Select::make('brand')
                        ->label('Merk')
                        ->options([
                            'Honda' => 'Honda',
                            'Yamaha' => 'Yamaha',
                            'Suzuki' => 'Suzuki',
                            'Piaggio' => 'Piaggio',
                            'Kawasaki' => 'Kawasaki',
                            'TVS' => 'TVS'
                        ])
                        ->required(),
    
                    TextInput::make('type')
                        ->label('Tipe')
                        ->required(),
    
                    TextInput::make('cc')
                        ->label('CC')
                        ->numeric()
                        ->required()
                        ->prefix('CC'),
    
                    TextInput::make('year')
                        ->label('Tahun')
                        ->numeric()
                        ->required(),
    
                    TextInput::make('color')
                        ->label('Warna')
                        ->required(),
    
                    Select::make('status')
                        ->label('Status')
                        ->options([
                            'Tersedia' => 'Tersedia',
                            'Disewa' => 'Disewa',
                            'Maintenance' => 'Maintenance',
                        ])
                        ->required(),
    
                    DatePicker::make('oil_date')
                        ->label('Jadwal Ganti Oli')
                        ->required(),
    
                    DatePicker::make('stnk_date')
                        ->label('Jadwal STNK Aktif')
                        ->required(),
    
                    TextInput::make('daily_price')
                        ->label('Harga / Hari')
                        ->numeric()
                        ->prefix('Rp')
                        ->required(),
    
                    TextInput::make('weekly_price')
                        ->label('Harga / Minggu')
                        ->numeric()
                        ->prefix('Rp')
                        ->required(),
    
                    TextInput::make('monthly_price')
                        ->label('Harga / Bulan')
                        ->numeric()
                        ->prefix('Rp')
                        ->required(),
    
                    SpatieMediaLibraryFileUpload::make('photo')
                        ->label('Foto Motor')
                        ->collection('motorcycles')
                        ->image()
                        ->imagePreviewHeight('200')
                        ->loadingIndicatorPosition('left')
                        ->panelAspectRatio('2:1')
                        ->panelLayout('integrated')
                        ->removeUploadedFileButtonPosition('right')
                        ->uploadButtonPosition('left')
                        ->downloadable()
                        ->required(),
                ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('plate_number')
                    ->label('No. Polisi')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('brand')
                    ->label('Merk'),

                TextColumn::make('type')
                    ->label('Tipe'),

                BadgeColumn::make('status')
                    ->colors([
                        'success' => 'Tersedia',
                        'warning' => 'Disewa',
                        'danger' => 'Maintenance',
                    ])
                    ->label('Status'),

                TextColumn::make('daily_price')
                    ->label('Harga/Hari')
                    ->money('IDR'),

                TextColumn::make('weekly_price')
                    ->label('Harga/Minggu')
                    ->money('IDR'),

                TextColumn::make('monthly_price')
                    ->label('Harga/Bulan')
                    ->money('IDR'),

                TextColumn::make('oil_date')
                    ->label('Ganti Oli')
                    ->date(),

                TextColumn::make('stnk_date')
                    ->label('STNK Aktif')
                    ->date(),
            ])->defaultSort('plate_number')
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            MaintenancesRelationManager::class,
            StnkDatesRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMotorcycles::route('/'),
            'create' => Pages\CreateMotorcycle::route('/create'),
            'edit' => Pages\EditMotorcycle::route('/{record}/edit'),
        ];
    }
}
