<?php

namespace App\Filament\Pages;

use App\Filament\Resources\MotorcycleResource;
use Filament\Pages\Page;
use App\Models\Motorcycle;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Filament\Notifications\Notification;


class ReminderList extends Page
{
    protected static string $resource = MotorcycleResource::class;

    protected static string $view = 'filament.resources.motorcycle-resource.pages.reminder-list';
    protected static ?string $navigationIcon = 'heroicon-o-bell';
    protected static ?string $navigationGroup = 'Rental Motor';
    protected static ?string $title = 'Reminder Perawatan';

    public $reminders;

    public function mount(): void
    {
        $today = Carbon::today();

        // Reminder STNK: 2 minggu ke depan
        $stnkThreshold = $today->copy()->addDays(14);

        // Reminder Oli: 5 hari ke depan
        $oilThreshold = $today->copy()->addDays(5);

        $this->reminders = Motorcycle::query()
            ->get()
            ->filter(function ($motor) use ($stnkThreshold, $oilThreshold, $today) {
                return 
                    (Carbon::parse($motor->stnk_date)->isBetween($today, $stnkThreshold)) ||
                    (Carbon::parse($motor->oil_date)->isBetween($today, $oilThreshold));
            })
            ->map(function ($motor) use ($today, $stnkThreshold, $oilThreshold) {
                return [
                    'motorcycle' => $motor,
                    'reminders' => collect([
                        Carbon::parse($motor->stnk_date)->isBetween($today, $stnkThreshold)
                            ? 'STNK akan jatuh tempo pada ' . Carbon::parse($motor->stnk_date)->format('d M Y')
                            : null,
                        Carbon::parse($motor->oil_date)->isBetween($today, $oilThreshold)
                            ? 'Ganti Oli pada ' . Carbon::parse($motor->oil_date)->format('d M Y')
                            : null,
                    ])->filter()->values()->all(),
                ];
            });
    }

    public static function getNavigationBadge(): ?string
    {
        $today = now();
        $stnkThreshold = $today->copy()->addDays(14);
        $oilThreshold = $today->copy()->addDays(5);

        $count = Motorcycle::query()
            ->get()
            ->filter(function ($motor) use ($stnkThreshold, $oilThreshold, $today) {
                return 
                    (Carbon::parse($motor->stnk_date)->isBetween($today, $stnkThreshold)) ||
                    (Carbon::parse($motor->oil_date)->isBetween($today, $oilThreshold));
            })
            ->count();

        return $count > 0 ? (string) $count : null;
    }

    // ✅ Ini WAJIB agar muncul di sidebar:
    public static function shouldRegisterNavigation(): bool
    {
        return true;
    }

    public static function getNavigationGroup(): ?string
    {
        return 'Kendaraan';
    }

    public static function getNavigationLabel(): string
    {
        return 'Reminder Motor';
    }

    public static function getNavigationSort(): ?int
    {
        return 5; // urutan di sidebar, semakin kecil semakin atas
    }
}
