<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Motorcycle;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class SendReminderWhatsApp extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-reminder-whats-app';

    protected $description = 'Kirim WhatsApp reminder STNK dan ganti oli';

    public function handle()
    {
        $today = Carbon::today();

        $motorcycles = Motorcycle::all();

        foreach ($motorcycles as $motorcycle) {
            $reminders = [];

            // Reminder STNK: 14 hari sebelum
            if ($motorcycle->stnk_date && Carbon::parse($motorcycle->stnk_date)->subDays(14)->isSameDay($today)) {
                $reminders[] = "Perpanjangan STNK untuk motor {$motorcycle->plate_number}";
            }

            // Reminder Ganti Oli: 5 hari sebelum
            if ($motorcycle->oil_date && Carbon::parse($motorcycle->oil_date)->subDays(5)->isSameDay($today)) {
                $reminders[] = "Ganti oli motor {$motorcycle->plate_number}";
            }

            if (!empty($reminders)) {
                $message = implode("\n", $reminders);
                $this->sendWhatsApp($message);
            }
        }

        $this->info('Reminder WA dikirim.');
    }

    protected function sendWhatsApp($message)
    {
        // Contoh API Wablas (ganti dengan token/URL kamu sendiri)
        $token = config('services.wablas.token'); // simpan di .env
        $phone = config('services.wablas.target_phone'); // nomor penerima

        Http::withHeaders([
            'Authorization' => $token,
        ])->post('https://console.wablas.com/api/send-message', [
            'phone' => $phone,
            'message' => $message,
        ]);
    }
}
