<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Rental;
use Carbon\Carbon;

class MarkLateRentals extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:mark-late-rentals';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Tandai rental yang melewati end_date dan belum dikembalikan sebagai late';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $today = Carbon::today();

        $updated = Rental::where('status', 'ongoing')
            ->whereDate('end_date', '<', $today)
            ->update(['status' => 'late']);

        $this->info("{$updated} rental ditandai sebagai late.");
    }
}
