

<?php $__env->startSection('content'); ?>
<div 
    class="container mx-auto px-4 py-8"
    x-data="{ open: false, book: {} }"
>
    <form method="GET" action="<?php echo e(route('books.index')); ?>" class="mb-6">
        <input
            type="text"
            name="search"
            value="<?php echo e(request('search')); ?>"
            placeholder="Cari judul buku..."
            class="w-full p-2 border rounded"
        />
    </form>

    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
        <?php $__empty_1 = true; $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <img src="<?php echo e(asset('storage/' . $book->cover_image)); ?>"
                     alt="<?php echo e($book->title); ?>"
                     class="w-full h-40 object-cover"
                >
                <div class="p-4">
                    <h3 class="text-md font-semibold"><?php echo e($book->title); ?></h3>
                    <p class="text-sm text-gray-600">Penulis: <?php echo e($book->authors->first()->name ?? '-'); ?></p>
                    <p class="text-sm text-gray-600">Kategori: <?php echo e($book->categories->first()->name ?? '-'); ?></p>
                    <button
                        type="button"
                        class="mt-2 inline-block text-blue-600 text-sm"
                        @click="
                            book = {
                                cover: '<?php echo e(asset('storage/' . $book->cover_image)); ?>',
                                title: '<?php echo e($book->title); ?>',
                                author: '<?php echo e($book->authors->first()->name ?? '-'); ?>',
                                category: '<?php echo e($book->categories->first()->name ?? '-'); ?>',
                                publisher: '<?php echo e($book->publisher->name ?? '-'); ?>',
                                location: '<?php echo e($book->location->name ?? '-'); ?>',
                                description: `<?php echo e($book->description); ?>`
                            };
                            open = true;
                        "
                    >
                        Lihat Detail
                    </button>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p>Tidak ada buku ditemukan.</p>
        <?php endif; ?>
    </div>

    <div class="mt-6">
        <?php echo e($books->withQueryString()->links()); ?>

    </div>

    <!-- Modal -->
    <div class="fixed inset-0 bg-gray-900/50 flex items-center justify-center z-50" x-show="open" x-cloak>
        <div class="bg-white rounded-lg max-w-lg w-full p-6 relative">
            <button class="absolute top-2 right-2 text-gray-500" @click="open = false">&times;</button>
            <img :src="book.cover" class="w-full h-48 object-cover rounded mb-4" alt="">
            <h2 class="text-2xl font-bold mb-2" x-text="book.title"></h2>
            <p class="text-gray-600"><strong>Penulis:</strong> <span x-text="book.author"></span></p>
            <p class="text-gray-600"><strong>Kategori:</strong> <span x-text="book.category"></span></p>
            <p class="text-gray-600"><strong>Penerbit:</strong> <span x-text="book.publisher"></span></p>
            <p class="text-gray-600"><strong>Lokasi:</strong> <span x-text="book.location"></span></p>
            <p class="mt-4 text-sm text-gray-700" x-text="book.description"></p>
        </div>
    </div>
</div>

<!-- Tambahkan Alpine.js -->
<script src="//unpkg.com/alpinejs" defer></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\BookCatalogue\resources\views/catalog/books/index.blade.php ENDPATH**/ ?>