@extends('layouts.app')

@section('content')
<div 
    class="container mx-auto px-4 py-8"
    x-data="{ open: false, book: {} }"
>
    <form method="GET" action="{{ route('books.index') }}" class="mb-6">
        <input
            type="text"
            name="search"
            value="{{ request('search') }}"
            placeholder="Cari judul buku..."
            class="w-full p-2 border rounded"
        />
    </form>

    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
        @forelse ($books as $book)
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <img src="{{ asset('storage/' . $book->cover_image) }}"
                     alt="{{ $book->title }}"
                     class="w-full h-40 object-cover"
                >
                <div class="p-4">
                    <h3 class="text-md font-semibold">{{ $book->title }}</h3>
                    <p class="text-sm text-gray-600">Penulis: {{ $book->authors->first()->name ?? '-' }}</p>
                    <p class="text-sm text-gray-600">Kategori: {{ $book->categories->first()->name ?? '-' }}</p>
                    <button
                        type="button"
                        class="mt-2 inline-block text-blue-600 text-sm"
                        @click="
                            book = {
                                cover: '{{ asset('storage/' . $book->cover_image) }}',
                                title: '{{ $book->title }}',
                                author: '{{ $book->authors->first()->name ?? '-' }}',
                                category: '{{ $book->categories->first()->name ?? '-' }}',
                                publisher: '{{ $book->publisher->name ?? '-' }}',
                                location: '{{ $book->location->name ?? '-' }}',
                                description: `{{ $book->description }}`
                            };
                            open = true;
                        "
                    >
                        Lihat Detail
                    </button>
                </div>
            </div>
        @empty
            <p>Tidak ada buku ditemukan.</p>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $books->withQueryString()->links() }}
    </div>

    <!-- Modal -->
    <div class="fixed inset-0 bg-gray-900/50 flex items-center justify-center z-50" x-show="open" x-cloak>
        <div class="bg-white rounded-lg max-w-lg w-full p-6 relative">
            <button class="absolute top-2 right-2 text-gray-500" @click="open = false">&times;</button>
            <img :src="book.cover" class="w-full h-48 object-cover rounded mb-4" alt="">
            <h2 class="text-2xl font-bold mb-2" x-text="book.title"></h2>
            <p class="text-gray-600"><strong>Penulis:</strong> <span x-text="book.author"></span></p>
            <p class="text-gray-600"><strong>Kategori:</strong> <span x-text="book.category"></span></p>
            <p class="text-gray-600"><strong>Penerbit:</strong> <span x-text="book.publisher"></span></p>
            <p class="text-gray-600"><strong>Lokasi:</strong> <span x-text="book.location"></span></p>
            <p class="mt-4 text-sm text-gray-700" x-text="book.description"></p>
        </div>
    </div>
</div>

<!-- Tambahkan Alpine.js -->
<script src="//unpkg.com/alpinejs" defer></script>
@endsection