<x-filament::page>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
        @foreach ($books as $book)
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <img src="{{ $book->cover ? asset('storage/' . $book->cover) : 'https://via.placeholder.com/150' }}" 
                     alt="{{ $book->title }}" class="w-full h-48 object-cover">

                <div class="p-4">
                    <h3 class="text-lg font-semibold">{{ $book->title }}</h3>
                    <p class="text-xs text-gray-500">
                        {{ $book->categories?->name ?? '-' }} | {{ $book->publisher?->name ?? '-' }}
                    </p>
                </div>
            </div>
        @endforeach
    </div>

    <div class="mt-6">
        {{ $books->links() }}
    </div>
</x-filament::page>