<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Book;

class BookCatalogController extends Controller
{
    public function index(Request $request)
    {
        $books = Book::query()
            ->with(['authors', 'categories'])
            ->when($request->search, function ($query, $search) {
                $query->where('title', 'like', "%{$search}%");
            })
            ->paginate(12); // untuk grid, bagus pakai pagination

        return view('catalog.books.index', compact('books'));
    }

    // public function index()
    // {
    //     $books = Book::with(['authors', 'categories', 'publisher', 'location'])
    //         ->paginate(12);

    //     return view('catalog.books.catalog', compact('books'));
    // }
}
