<x-filament-panels::page>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <x-filament::card>
            <h2 class="text-lg font-semibold">Total Penjualan Bulan Ini</h2>
            <p class="text-2xl text-primary mt-2">Rp {{ number_format($totalSales, 0, ',', '.') }}</p>
        </x-filament::card>

        <x-filament::card>
            <h2 class="text-lg font-semibold">Barang Paling Laku</h2>
            <ul class="mt-2 space-y-1">
                @foreach ($topProducts as $product)
                    <li>{{ $product->inventory->product_name ?? '-' }} ({{ $product->total_quantity }} pcs)</li>
                @endforeach
            </ul>
        </x-filament::card>

        <x-filament::card>
            <h2 class="text-lg font-semibold">Grafik Penjualan Mingguan</h2>
            <livewire:weekly-sales-chart :data="$weeklySales" />
        </x-filament::card>
    </div>
</x-filament-panels::page>
