<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Builder;

class Supplier extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'npwp', 'contact_person', 'phone', 'address', 'type', 'is_active'];

    public function purchases()
    {
        return $this->hasMany(Purchasing::class);
    }

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true); // atau '1' kalau pakai boolean
    }
}
