<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SalesItem extends Model
{
    use HasFactory;

    protected $fillable = ['sale_id', 'inventory_id', 'quantity', 'selling_price', 'subtotal'];

    public function sale()
    {
        return $this->belongsTo(Sales::class, 'sale_id');
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory::class);
    }
}
