<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sales;
use Illuminate\Support\Facades\View;
use Barryvdh\DomPDF\Facade\Pdf;

class InvoiceController extends Controller
{
    public function print(Sales $sale) // <--- Tetap pakai $sale, nama variabel boleh apa saja
    {
        $sale->load('items.inventory');

        $pdf = Pdf::loadView('pdf.invoice', [
            'sale' => $sale, // Blade view tetap pakai 'sale' agar konsisten
        ]);

        return $pdf->stream("invoice-{$sale->invoice_number}.pdf");
    }
}
