<?php

namespace App\Filament\Pages;

use App\Models\Sales;
use App\Models\SalesItem;
use App\Models\Inventory;
use Filament\Pages\Page;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardOverview extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-presentation-chart-line';
    protected static string $view = 'filament.pages.dashboard-overview';

    public $totalSales = 0;
    public $topProducts = [];
    public $weeklySales = [];

    public function mount()
    {
        $this->loadData();
    }

    protected function loadData()
    {
        // Total Penjualan Bulan Ini
        $this->totalSales = SalesItem::whereHas('sale', function ($q) {
            $q->whereMonth('sale_date', now()->month)
              ->whereYear('sale_date', now()->year);
        })->sum('subtotal');

        // Barang Paling Laku
        $this->topProducts = SalesItem::select('inventory_id', DB::raw('SUM(quantity) as total_quantity'))
            ->groupBy('inventory_id')
            ->orderByDesc('total_quantity')
            ->with('inventory') // Pastikan relasi di SalesItem
            ->take(5)
            ->get();

        // Grafik Penjualan Mingguan (7 hari terakhir)
        $this->weeklySales = Sales::select(DB::raw('DATE(sale_date) as date'), DB::raw('SUM(subtotal) as total'))
            ->join('sales_items', 'sales.id', '=', 'sales_items.sale_id')
            ->where('sale_date', '>=', now()->subDays(6))
            ->groupBy('date')
            ->orderBy('date')
            ->get()
            ->mapWithKeys(fn($item) => [Carbon::parse($item->date)->format('D') => (float) $item->total])
            ->toArray();
    }
}
