<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Nota Gadai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 0;
        }
        .center {
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .row {
            display: flex;
            justify-content: space-between;
        }
        img.logo {
            width: 60px;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="center">
        <img src="{{ public_path('images/logo.png') }}" class="logo" alt="Logo">
        <div class="bold">BUKTI GADAI</div>
    </div>

    <div class="line"></div>

    <div>Nota: {{ $gadget->nomor_nota }}</div>
    <div>Tanggal: {{ \Carbon\Carbon::now()->format('d/m/Y') }}</div>
    <div>Nama: {{ $gadget->customer->name ?? '-' }}</div>
    <div>Barang: {{ $gadget->brand }} {{ $gadget->model }}</div>

    <div class="line"></div>

    <div class="row"><span>Nilai Gadai:</span><span>Rp{{ number_format($gadget->pawn_value) }}</span></div>
    <div class="row"><span>Biaya Admin:</span><span>Rp{{ number_format($gadget->admin_fee) }}</span></div>
    <div class="row"><span>Jasa Gadai:</span><span>Rp{{ number_format($gadget->service_fee) }}</span></div>

    <div class="line"></div>
    @if ($gadget->denda > 0)
        <div class="row"><span>Denda:</span><span>Rp{{ number_format($gadget->denda) }}</span></div>
    @endif
    <div class="line"></div>

    @php
        $total = $gadget->pawn_value + $gadget->admin_fee + $gadget->service_fee + ($gadget->denda ?? 0);
    @endphp
    <div class="row bold"><span>Total:</span><span>Rp{{ number_format($total) }}</span></div>

    <div class="line"></div>

    <div>Jatuh Tempo: {{ \Carbon\Carbon::parse($gadget->end_date)->format('d/m/Y') }}</div>

    <div class="line"></div>

    <div class="center" style="margin-top: 10px;">Terima kasih</div>
</body>
</html>