<x-filament::page>
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold">Laporan Keuangan</h2>
        <form method="get">
            <select name="filter" onchange="this.form.submit()" class="border rounded px-2 py-1">
                <option value="today" @selected($filter === 'today')>Hari Ini</option>
                <option value="week" @selected($filter === 'week')>Mingguan</option>
                <option value="month" @selected($filter === 'month')>Bulanan</option>
            </select>
        </form>
    </div>

    <x-filament::card>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div class="text-lg font-bold mb-2">Pendapatan</div>
                    <p>Total Pendapatan: Rp{{ number_format($income) }}</p>
                    <ul class="mt-2 text-sm text-gray-600">
                        <li>Biaya Admin: Rp{{ number_format($admin_fee) }}</li>
                        <li>Jasa Gadai: Rp{{ number_format($jasa) }}</li>
                        <li>Denda: Rp{{ number_format($denda) }}</li>
                        <li>Perpanjangan: Rp{{ number_format($perpanjangan) }}</li>
                    </ul>
                </x-filament::card>
            </div>
            <br>
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div>
                        <h3 class="font-semibold">B. Pengeluaran</h3>
                        <p>Total Transaksi Keluar: Rp{{ number_format($expense, 0, ',', '.') }}</p>
                    </div>
                </x-filament::card>
            </div>
            <br>
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div>
                        <h3 class="font-semibold">C. Kas</h3>
                        <p>Kas Masuk: Rp{{ number_format($kas_masuk, 0, ',', '.') }}</p>
                        <p>Kas Keluar: Rp{{ number_format($kas_keluar, 0, ',', '.') }}</p>
                        <p><strong>Sisa Saldo: Rp{{ number_format($kas_saldo, 0, ',', '.') }}</strong></p>
                    </div>
                </x-filament::card>
            </div>
        </div>
    </x-filament::card>
</x-filament::page>