<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 0;
        }

        .content {
            padding: 5px 10px;
            width: 100%;
        }

        .center {
            text-align: center;
        }

        .bold {
            font-weight: bold;
        }

        hr {
            border: 0;
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="center">
            <img src="{{ public_path('images/logo.png') }}" class="logo" alt="Logo">
            <div class="bold">BUKTI PERPANJANGAN</div>
        </div>
    
        <div class="line"></div>
    
        <div>Nota: {{ $gadget->nomor_nota }}</div>
        <div>Tanggal: {{ \Carbon\Carbon::now()->format('d/m/Y') }}</div>
        <div>Nama: {{ $gadget->customer->name ?? '-' }}</div>
        <div>Barang: {{ $gadget->brand }} {{ $gadget->model }}</div>
    
        <div class="line"></div>
    
        <div class="row"><span>Biaya Admin:</span><span>Rp{{ number_format($gadget->service_fee) }}</span></div>
    
        <div class="line"></div>
    
        <div>Jatuh Tempo: {{ \Carbon\Carbon::parse($gadget->end_date)->format('d/m/Y') }}</div>
    
        <div class="line"></div>
    
        <div class="center" style="margin-top: 10px;">Terima kasih</div>
    </div>
</body>
</html>