<x-filament::page>
    <form wire:submit.prevent="applyFilters">
        <div class="flex flex-wrap gap-4 items-end">
            <div class="w-48">
                <label class="block text-sm font-medium">Rentang Waktu</label>
                <select wire:model="range" class="filament-input w-full">
                    <option value="daily">Harian</option>
                    <option value="weekly">Mingguan</option>
                    <option value="monthly">Bulanan</option>
                    <option value="custom">Custom</option>
                </select>
            </div>

            <div class="w-48">
                <label class="block text-sm font-medium">Dari</label>
                <input type="date" wire:model="start_date" class="filament-input w-full" />
            </div>

            <div class="w-48">
                <label class="block text-sm font-medium">Sampai</label>
                <input type="date" wire:model="end_date" class="filament-input w-full" />
            </div>

            <div class="pt-5">
                <button type="submit" class="filament-button filament-button--primary">
                    Terapkan
                </button>
            </div>
        </div>
    </form>

    <x-filament::card>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div class="text-lg font-bold mb-2">Pendapatan</div>
                    <p>Total Pendapatan: Rp{{ number_format($income) }}</p>
                    <ul class="mt-2 text-sm text-gray-600">
                        <li>Biaya Admin: Rp{{ number_format($admin_fee) }}</li>
                        <li>Jasa Gadai: Rp{{ number_format($jasa) }}</li>
                        <li>Denda: Rp{{ number_format($denda) }}</li>
                        <li>Perpanjangan: Rp{{ number_format($perpanjangan) }}</li>
                    </ul>
                </x-filament::card>
            </div>
            <br>
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div>
                        <h3 class="font-semibold">B. Pengeluaran</h3>
                        <p>Total Transaksi Keluar: Rp{{ number_format($expense, 0, ',', '.') }}</p>
                    </div>
                </x-filament::card>
            </div>
            <br>
            <div class="grid grid-cols-1 gap-4">
                <x-filament::card>
                    <div>
                        <h3 class="font-semibold">C. Kas</h3>
                        <p>Kas Masuk: Rp{{ number_format($kas_masuk, 0, ',', '.') }}</p>
                        <p>Kas Keluar: Rp{{ number_format($kas_keluar, 0, ',', '.') }}</p>
                        <p><strong>Sisa Saldo: Rp{{ number_format($kas_saldo, 0, ',', '.') }}</strong></p>
                    </div>
                </x-filament::card>
            </div>
        </div>
    </x-filament::card>
</x-filament::page>