<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Gadget extends Model
{
    protected $fillable = ['customer_id', 'nomor_nota', 'brand','model','imei','pawn_value','admin_fee','service_fee', 'denda',
        'start_date','end_date','status','hp_ram','hp_rom','cf_case_condition','cf_case_quality',
        'cf_glue_marks','cf_lcd_condition','cf_lcd_quality',
        'cs_battery_condition', 'cs_battery_quality',
        'cs_restart3x_condition','cs_screen_condition','cs_screen_quality',
        'cs_sensor_condition','cs_sound_condition','cs_flashlight_condition','cs_screenfunction_condition',
        'cs_front_cam_condition','cs_front_cam_quality','cs_main_cam_condition','cs_main_cam_quality',
        'cs_signal_condition','imei_box_phone','charger_condition','charger_status','box','account_check',
        'completeness','signature','device_check_playstore','user_id', 'extension_count'];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function cashTransactions()
    {
        return $this->morphMany(CashTransaction::class, 'reference');
    }
}
