<?php

namespace App\Http\Controllers;

use App\Models\Gadget;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class NotaGadaiController extends Controller
{
    public function cetakNota(Gadget $gadget)
    {
        $pdf = Pdf::loadView('pdf.nota-gadai', [
            'gadget' => $gadget,
            'customer' => $gadget->customer, // pastikan relasi ada
        ])->setPaper([0, 0, 162, 500], 'portrait'); // ukuran 55mm x 130mm dalam points;

        return $pdf->stream('nota-gadai-' . $gadget->nomor_nota . '.pdf');
    }

    public function cetakNotaPerpanjangan(Gadget $gadget)
    {
        $pdf = Pdf::loadView('pdf.nota-gadai-perpanjangan', [
            'gadget' => $gadget,
            'customer' => $gadget->customer, // pastikan relasi ada
        ])->setPaper([0, 0, 162, 500], 'portrait'); // ukuran 55mm x 130mm dalam points;

        return $pdf->stream('nota-gadai-perpanjangan-' . $gadget->nomor_nota . '.pdf');
    }
}
