<?php

namespace App\Filament\Widgets;

use App\Models\Transaction;
use Filament\Widgets\Widget;
use Illuminate\Support\Carbon;
use Leandrocfe\FilamentApexCharts\Widgets\ApexChartWidget;

class WeeklyFinanceChart extends ApexChartWidget
{
    protected static ?string $heading = 'Rekap Keuangan Mingguan';
    protected static ?string $chartId = 'weekly-finance';
    protected int|string|array $columnSpan = 'full';

    protected function getOptions(): array
    {
        $labels = [];
        $cashInData = [];
        $cashOutData = [];

        $now = now();
        $startOfWeek = $now->copy()->startOfWeek();

        for ($i = 0; $i < 7; $i++) {
            $date = $startOfWeek->copy()->addDays($i);
            $labels[] = $date->format('D');

            $cashIn = Transaction::where('type', 'cash_in')
                ->whereDate('created_at', $date)
                ->sum('amount');

            $cashOut = Transaction::where('type', 'cash_out')
                ->whereDate('created_at', $date)
                ->sum('amount');

            $cashInData[] = $cashIn;
            $cashOutData[] = $cashOut;
        }

        return [
            'chart' => [
                'type' => 'bar',
                'height' => 300,
            ],
            'series' => [
                [
                    'name' => 'Uang Masuk',
                    'data' => $cashInData,
                ],
                [
                    'name' => 'Uang Keluar',
                    'data' => $cashOutData,
                ],
            ],
            'xaxis' => [
                'categories' => $labels,
            ],
        ];
    }
}