<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Widgets\StatsOverviewWidget\Card;
use App\Models\Transaction;
use Illuminate\Support\Carbon;

class FinanceSummaryWidget extends BaseWidget
{
    public ?string $filter = 'today';
    
    protected function getCards(): array
    {
        $query = Transaction::query();

        // Filter fleksibel
        switch ($this->filter) {
            case 'today':
                $query->whereDate('created_at', Carbon::today());
                break;
            case 'week':
                $query->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
                break;
            case 'month':
                $query->whereMonth('created_at', now()->month);
                break;
        }

        $cashIn = (clone $query)->where('type', 'cash_in')->sum('amount');
        $cashOut = (clone $query)->where('type', 'cash_out')->sum('amount');

        return [
            Card::make('Total Uang Masuk', 'Rp ' . number_format($cashIn, 0, ',', '.'))
                ->description(strtoupper($this->filter)),
            Card::make('Total Uang Keluar', 'Rp ' . number_format($cashOut, 0, ',', '.'))
                ->description(strtoupper($this->filter)),
        ];
    }

    protected function getFilters(): ?array
    {
        return [
            'today' => 'Hari Ini',
            'week' => 'Minggu Ini',
            'month' => 'Bulan Ini',
        ];
    }
}