<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // 1. Jika ingin auto-set default password
        $data['password'] = bcrypt('password123');

        // 2. ATAU jika field password diisi manual dan perlu di-hash
        // $data['password'] = bcrypt($data['password']);

        return $data;
    }
}
