<?php

namespace App\Filament\Resources\TransactionResource\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Card;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;
use Filament\Tables\Filters\Filter;
use Carbon\Carbon;

class TransactionSummary extends BaseWidget
{
    protected static ?string $pollingInterval = null;
    protected static bool $isLazy = false;

    protected function getCards(): array
    {
        $from = request()->input('tableFilters.date_range.from');
        $until = request()->input('tableFilters.date_range.until');

        $query = Transaction::query();

        if ($from && $until) {
            $query->whereBetween('created_at', [
                Carbon::parse($from)->startOfDay(),
                Carbon::parse($until)->endOfDay(),
            ]);
        }

        $cashIn = (clone $query)->where('type', 'cash_in')->sum('amount');
        $cashOut = (clone $query)->where('type', 'cash_out')->sum('amount');

        return [
            Card::make('Total Uang Masuk', 'Rp ' . number_format($cashIn, 0, ',', '.'))
                ->description('Tipe: cash_in')
                ->color('success'),

            Card::make('Total Uang Keluar', 'Rp ' . number_format($cashOut, 0, ',', '.'))
                ->description('Tipe: cash_out')
                ->color('danger'),
        ];
    }

    protected function getColumns(): int
    {
        return 2;
    }

    protected static string $resource = \App\Filament\Resources\TransactionResource::class;
}
