<?php

namespace App\Filament\Resources\TransactionResource\Pages;

use App\Filament\Resources\TransactionResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Models\Transaction;
use Carbon\Carbon;

class CreateTransaction extends CreateRecord
{
    protected static string $resource = TransactionResource::class;

    protected function afterCreate(): void
    {
        $gadget = $this->record->gadget;

        $start = Carbon::parse($gadget->start_date);
        $end = Carbon::parse($gadget->end_date);
        $redeemDate = Carbon::parse($this->record->redeem_date);

        $lateDays = $redeemDate->diffInDays($end, false); //negatif jika telat
        $lateDays = $lateDays < 0 ? abs($lateDays) : 0;

        //Hitung denda
        $penaltyFee = 0;
        if ($lateDays > 0 && $lateDays <= 7) {
            $penaltyFee = $gadget->pawn_value * 0.05;
        }elseif ($lateDays >= 8 && $lateDays <= 31) {
            $penaltyFee = $gadget->pawn_value * 0.10;
        }

        //Hitung biaya administrasi
        $adminFee = match (true) {
            $gadget->pawn_value <= 500000 => 10000,
            $gadget->pawn_value <= 999000 => 15000,
            default => 20000,
        };

        $this->record->update([
            'penalty_fee' => $penaltyFee,
            'total_payment' => $gadget->service_fee + $adminFee + $penaltyFee,
        ]);

        $gadget->update([
            'status' => 'redeemed',
        ]);

        //Transaksi pemasukan (total pembayaran)
        Transaction::create([
            'type' => 'cash_in',
            'gadget_id' => $gadget->id,
            'user_id' => auth()->id(),
            'amount' => $this->record->total_payment,
            'category' => 'redeem_in',
            'notes' => 'Pembayaran tebusan HP ' . $gadget->brand . ' ' . $gadget->model,
        ]);

        // Pisahkan detail laba (opsional, tapi bermanfaat)
        Transaction::insert([
            [
                'type' => 'cash_in',
                'gadget_id' => $gadget->id,
                'user_id' => auth()->id(),
                'amount' => $gadget->service_fee,
                'category' => 'jasa',
                'notes' => 'Jasa gadai HP ' . $gadget->brand . ' ' . $gadget->model,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'type' => 'cash_in',
                'gadget_id' => $gadget->id,
                'user_id' => auth()->id(),
                'amount' => $adminFee,
                'category' => 'admin',
                'notes' => 'Biaya admin HP ' . $gadget->brand . ' ' . $gadget->model,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'type' => 'cash_in',
                'gadget_id' => $gadget->id,
                'user_id' => auth()->id(),
                'amount' => $penaltyFee,
                'category' => 'denda',
                'notes' => 'Denda keterlambatan HP ' . $gadget->brand . ' ' . $gadget->model,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
