<?php

namespace App\Filament\Resources\GadgetResource\Pages;

use App\Filament\Resources\GadgetResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use App\Models\Transaction;
use App\Models\CashTransaction;
use Filament\Notifications\Notification;

class EditGadget extends EditRecord
{
    protected static string $resource = GadgetResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
    
    public function afterSave(): void
    {
        DB::transaction(function () {
            $nota = $this->record->nomor_nota;
            $id = $this->record->id;
    
            // 1. Hapus transaksi sebelumnya berdasarkan nomor nota
            Transaction::where('nomor_nota', $nota)->delete();
            CashTransaction::where('reference_id', $id)->delete();
        
            // 2. Buat ulang transaksi baru
            Transaction::create([
                'nomor_nota' => $this->record->nomor_nota,
                'type' => 'cash_out',
                'category' => 'pawn_out',
                'gadget_id' => $this->record->id,
                'user_id' => auth()->id(),
                'amount' => $this->record->pawn_value,
                'due_date' => $this->record->end_date,
                'notes' => 'Pencairan HP ' . $this->record->brand . ' ' . $this->record->model,
            ]);
            Transaction::create([
                'nomor_nota' => $this->record->nomor_nota,
                'type' => 'cash_in',
                'category' => 'admin',
                'gadget_id' => $this->record->id,
                'user_id' => auth()->id(),
                'amount' => $this->record->admin_fee,
                'due_date' => $this->record->end_date,
                'notes' => 'Biaya Administrasi ' . $this->record->brand . ' ' . $this->record->model,
            ]);
            
            // 3. Buat ulang cash transaction baru
            CashTransaction::create([
                'date' => now(),
                'description' => 'Pencairan Gadai: ' . $this->record->brand . ' ' . $this->record->model,
                'type' => 'debit', // uang keluar dari kas
                'amount' => $this->record->pawn_value, // asumsi kamu punya ini
                'reference_type' => Gadget::class,
                'reference_id' => $this->record->id,
                'created_by' => auth()->id(),
            ]);
            CashTransaction::create([
                'date' => now(),
                'description' => 'Biaya Admin Gadai: ' . $this->record->brand . ' ' . $this->record->model,
                'type' => 'credit', // uang masuk ke kas
                'amount' => $this->record->admin_fee, // asumsi kamu punya ini
                'reference_type' => Gadget::class,
                'reference_id' => $this->record->id,
                'created_by' => auth()->id(),
            ]);
        });
            
    
        Notification::make()
            ->title('Berhasil disimpan')
            ->success()
            ->body('Data berhasil diperbarui.')
            ->send();
    }
}
