<?php

namespace App\Filament\Resources\GadgetResource\Pages;

use App\Filament\Resources\GadgetResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateGadget extends CreateRecord
{
    protected static string $resource = GadgetResource::class;

    protected function afterCreate(): void
    {
        \App\Models\Transaction::create([
            'type' => 'cash_out',
            'category' => 'pawn_out',
            'gadget_id' => $this->record->id,
            'user_id' => auth()->id(),
            'amount' => $this->record->pawn_value,
            'due_date' => $this->record->end_date,
            'notes' => 'Pencarian HP' . $this->record->brand . $this->record->model,
        ]);
    }
}
