<?php

namespace App\Filament\Resources\DashboardResource\Pages;

use App\Filament\Resources\DashboardResource;
use Filament\Resources\Pages\Page;
use App\Filament\Widgets\FinanceSummaryWidget;

class Dashboard extends Page
{
    protected static string $resource = DashboardResource::class;

    protected static string $view = 'filament.resources.dashboard-resource.pages.dashboard';

    public function mount(): void
    {
        abort_unless(auth()->user()->hasRole('admin', 403));
    }

    protected function getHeaderWidgets(): array
    {
        return [
            FinanceSummaryWidget::class,
        ];
    }
}
