<?php

namespace App\Filament\Resources\CashTransactionResource\Widgets;

use Filament\Widgets\Widget;
use App\Models\CashTransaction;

class CashBalanceWidget extends Widget
{
    protected static string $view = 'filament.resources.cash-transaction-resource.widgets.cash-balance-widget';
    protected static ?int $sort = 1;

    public $balance;

    public function mount(): void
    {
        $debit = CashTransaction::where('type', 'debit')->sum('amount');
        $credit = CashTransaction::where('type', 'credit')->sum('amount');
        $this->balance = $credit - $debit ;
    }
}
