<?php

namespace App\Exports;

use App\Models\Transaction;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\CashTransaction;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class FinancialReportExport implements FromView
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate, $endDate)
    {
        $this->startDate = $startDate;
        $this->endDate   = $endDate;
    }

    public function view(): View
    {
        $transactions = Transaction::whereBetween('created_at', [$this->startDate, $this->endDate])->get();
        $cashTransactions = CashTransaction::whereBetween('date', [$this->startDate, $this->endDate])->get();

        $income = $transactions->where('type', 'cash_in')->sum('amount');
        $expense = $transactions->where('type', 'cash_out')->sum('amount');
        $kasMasuk = $cashTransactions->where('type', 'credit')->sum('amount');
        $kasKeluar = $cashTransactions->where('type', 'debit')->sum('amount');

        return view('exports.financial-report', [
            'transactions'     => $transactions,
            'cashTransactions' => $cashTransactions,
            'income'           => $income,
            'expense'          => $expense,
            'kasMasuk'         => $kasMasuk,
            'kasKeluar'        => $kasKeluar,
            'startDate'        => $this->startDate,
            'endDate'          => $this->endDate,
        ]);
    }
}
