<?php

namespace App\Exports;

use App\Models\CashTransaction;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class CashTransactionExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return CashTransaction::select(
            'date',
            'description',
            'type',
            'amount',
            'reference_type',
            'reference_id',
        )->get();
    }

    public function headings(): array
    {
        return [
            'Tanggal',
            'Deskripsi',
            'Tipe',
            'Jumlah',
            'Tipe Referensi',
            'ID Referensi',
        ];
    }
}
